using System;
using System.IO;
using BenTek.AdventOfCode.TwentyTwentyFive.Interfaces;

namespace BenTek.AdventOfCode.TwentyTwentyFive.Days
{
    class Day1 : IPuzzle
    {
        /// <inheritdoc />
        public string ExpectedTestValue1 => "5";

        public int StartingPosition => 50;
        public int Limit => 99;
        public string[] WrongAnswers => ["461", "5572", "7139", "7214", "7255", "6563", "8854", "6793", "8102", "7823", "7815"]; // 6684

        public string TestDataPath =>
            Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Data", "Day1", "sample_input.txt");
        public string RealDataPath =>
            Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Data", "Day1", "input.txt");
        
        public bool Test()
        {
            return true;
        }

        public string Run()
        {
            string input = Utilities.FileLoader.LoadFile(RealDataPath);
            return Logic(input);
        }

        /// <inheritdoc />
        public string Logic(string input)
        {
            string output1 = string.Empty;

            string[] lines = input.Split("\n");
            if (lines == null)
            {
                throw new Exception("Cannot split test input data");
            }
            
            int[] values = new int[lines.Length];
            
            for (int i = 0; i < lines.Length; i++)
            {
                string line = lines[i];
                string sign = line.Substring(0, 1);
                string value = line.TrimStart(sign.ToCharArray());
                int parsedValue = int.Parse(value);
                int coefficient = sign.Contains("R") ? 1 : -1;
                values[i] = parsedValue * coefficient;
            }

            int zeroCount = 0;
            int wrapCount = 0;
            int currentValue = StartingPosition;

            for (int i = 0; i < values.Length; i++)
            {
                currentValue = Wrap(currentValue, values[i], ref wrapCount);
                
                // Console.WriteLine($"The dial is rotated {values[i]} to point at {currentValue}");
                
                if (currentValue == 0)
                {
                    zeroCount++;
                }
            }

            output1 = zeroCount.ToString();
            string output2 = (wrapCount).ToString();
            
            if (!CheckOutput(output1))
            {
                return $"Error - {output1} is wrong answer for 1";
            }

            if (!CheckOutput(output2))
            {
                return $"Error - {output2} is wrong answer for 2";
            }

            return $"1: {output1}, 2: {output2}";
        }

        private int Wrap(int currentState, int delta, ref int wrapCount)
        {
            bool positive = delta > 0;
            int absDelta = (int)MathF.Abs(delta);

            for (int i = 0; i < absDelta; i++)
            {
                if (positive)
                {
                    currentState++;
                }
                else
                {
                    currentState--;
                }

                if (currentState < 0)
                {
                    currentState += 100;
                }
                else if (currentState > Limit)
                {
                    currentState -= 100;
                }

                if (currentState == 0)
                {
                    wrapCount++;
                }
            }

            return currentState;
        }

        private bool CheckOutput(string output)
        {
            if (WrongAnswers.Contains(output))
            {
                return false;
            }

            return true;
        }
    }
}
