using BenTek.AdventOfCode.TwentyTwentyFive.Interfaces;

namespace BenTek.AdventOfCode.TwentyTwentyFive.Days;

public class Day2Part1 : IPuzzle
{
    private class Bounds
    {
        public long Upper { get; }
        public long Lower { get; }

        public Bounds(long lower, long upper)
        {
            Upper = upper;
            Lower = lower;
        }

        public Bounds(string range)
        {
            string[] bounds = range.Split('-');
            Lower = long.Parse(bounds[0]);
            Upper = long.Parse(bounds[1]);
        }
    }
    
    /// <inheritdoc />
    public string ExpectedTestValue1 => "1227775554";
    
    public string TestDataPath =>
        Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Data", "Day2", "sample_input.txt");
    public string RealDataPath =>
        Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Data", "Day2", "input.txt");

    /// <inheritdoc />
    public bool Test()
    {
        string input = Utilities.FileLoader.LoadFile(TestDataPath);
        string result = Logic(input);
        bool passing = result == ExpectedTestValue1;
        if (!passing)
        {
            Console.WriteLine($"Expected {ExpectedTestValue1} but got {result}");
        }
        return passing;
    }

    /// <inheritdoc />
    public string Run()
    {
        string input = Utilities.FileLoader.LoadFile(RealDataPath);
        string result = Logic(input);
        return result;
    }

    /// <inheritdoc />
    public string Logic(string input)
    {
        List<Bounds> boundsList = new List<Bounds>();
        string[] ranges = input.Split(',');
        foreach (string range in ranges)
        {
            boundsList.Add(new Bounds(range));
        }

        List<long> invalidIDs = new List<long>();

        for (int i = 0; i < boundsList.Count; i++)
        {
            Bounds bounds = boundsList[i];
            
            for (long j = bounds.Lower; j <= bounds.Upper; j++)  // Inclusive
            {
                if (!IsValid(j))
                {
                    invalidIDs.Add(j);
                }
            }
        }

        long total = 0;

        foreach (long invalidID in invalidIDs)
        {
            total += invalidID;
        }

        return total.ToString();
    }

    private bool IsValid(long id)
    {
        string idStr = id.ToString();
        int length = idStr.Length;
        if (length % 2 == 1)
        {
            return true;
        }

        int subSize = length / 2;

        string left = idStr.Substring(0, subSize);
        string right = idStr.Substring(subSize);

        if (left.Length != right.Length)
        {
            Console.WriteLine($"Error: {left} is a different length to {right}");
        }

        return left != right;
    }
}